/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	GetMidPoint.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CLine.h"
#include "cApplication.h"

//	Returns the mid point of the given line

HRESULT GetMidPoint(ILine *line1, IPoint **point1)
{

	START_METHOD("GetMidPoint")

	HRESULT status = CONV_SUCCESS;

	// Get the start point of the line
	IPoint *startPoint = NULL;
	status = line1->GetStartPoint(&startPoint);
	CHECK_RETURN_STATUS(status)

	// Get the end point of the line
	IPoint *endPoint = NULL;
	status = line1->GetEndPoint(&endPoint);
	CHECK_RETURN_STATUS(status)

	IVector *vect1 = NULL;
	status = startPoint->GetPosition(&vect1);
	CHECK_RETURN_STATUS(status)

	IVector *vect2 = NULL;
	status = endPoint->GetPosition(&vect2);
	CHECK_RETURN_STATUS(status)

	double startX, startY, startZ, endX, endY, endZ, midX, midY, midZ;

	vect1->GetAt(0, &startX);
	vect1->GetAt(1, &startY);
	vect1->GetAt(2, &startZ);

	vect2->GetAt(0, &endX);
	vect2->GetAt(1, &endY);
	vect2->GetAt(2, &endZ);

	midX = (startX + endX) / 2;
	midY = (startY + endY) / 2;
	midZ = (startZ + endZ) / 2;

	IVector *vect3 = NULL;
	status = (GetCLASS(Vector))->CreateVector(midX, midY, midZ, &vect3);
	CHECK_RETURN_STATUS(status)

	IPoint *midPoint = NULL;
	status = (GetCLASS(Point))->CreatePoint(vect3, &midPoint);
	CHECK_RETURN_STATUS(status)

	*point1 = midPoint;

	END_METHOD("GetMidPoint")
}
